MAX_CONTROL_POINTS <- 3
MAX_SHUTOUT_TIME <- 10
SHUTOUT_ALERT_INTERVAL <- 1

m_ControlPointOwners <- array(MAX_CONTROL_POINTS,0);
m_nShutoutTeam <- 0;
m_bTeamIsShuttingOut <- false;
m_fShutoutStartedTime <- 0;
m_fShutoutNextAlert <- 0;

/////////////////////////////////////////

function OnMapSpawn()
{
	// reset respawn times
	SendToConsoleServer( "mp_respawnwavetime_t 10" );
	SendToConsoleServer( "mp_respawnwavetime_ct 10" );

	SendToConsoleServer( "mp_default_team_winner_no_objective 0" );

	EntFire( "@tr_postcapmoney_T_A","Enable", "", 0 );
	EntFire( "@tr_postcapmoney_CT_A","Enable", "", 0 );
	EntFire( "@tr_postcapmoney_T_B","Enable", "", 0 );
	EntFire( "@tr_postcapmoney_CT_B","Enable", "", 0 );
	EntFire( "@tr_postcapmoney_T_C","Enable", "", 0 );
	EntFire( "@tr_postcapmoney_CT_C","Enable", "", 0 );

	// set how much money a player will receive per 4.1 seconds when they are standing on a cap that their team owns
	EntFire( "@money_player_post_cap","SetMoneyAmount", "75", 0 );
}

function OnRoundEnded()
{
	for ( local i = 0; i<m_ControlPointOwners.len(); i++ )
	{
		m_ControlPointOwners[i] = 0;
	}

	m_nShutoutTeam = 0;
	m_bTeamIsShuttingOut = false;
	m_fShutoutStartedTime = 0;
	m_fShutoutNextAlert = 0;

	EntFire( "@rl_spawn_T_base_ENABLE","Trigger", "", 0 );
	EntFire( "@rl_spawn_T_A_DISABLE","Trigger", "", 0 );
	EntFire( "@rl_spawn_T_B_DISABLE","Trigger", "", 0 );
	EntFire( "@rl_spawn_T_C_DISABLE","Trigger", "", 0 );

	EntFire( "@rl_spawn_CT_base_ENABLE","Trigger", "", 0 );
	EntFire( "@rl_spawn_CT_A_DISABLE","Trigger", "", 0 );
	EntFire( "@rl_spawn_CT_B_DISABLE","Trigger", "", 0 );
	EntFire( "@rl_spawn_CT_C_DISABLE","Trigger", "", 0 );

	EntFire( "@buyzone_*","SetTeam_None", "", 0 );

	printl( "cp_dust2.nut: OnRoundEnded" );
}

// this function will set who is controlling what point.  Valid arguemnts for szTeam are "T" and "CT" or "none"
function CapturePoint( nPoint, nTeam )
{
	// the control points for this map translate as:
	// 0 == A, 1 == B, 2 == C

	//printl( "CapturePoint: Team " + nTeam + " is capturing point " + nPoint );
	//printl( "m_ControlPointOwners.len() == " + m_ControlPointOwners.len() );

	if ( nPoint >= m_ControlPointOwners.len() || nPoint < 0 )
	{
		printl( "ERROR: Trying to capture a point that doesn't exist!  (point " + nPoint + ")  Valid control point range is 0-" + (m_ControlPointOwners.len()-1) );
	}

	m_ControlPointOwners[nPoint] = nTeam;
	
	local nNumPoints_T = 0;
	local nNumPoints_CT = 0;
	for ( local i = 0; i<m_ControlPointOwners.len(); i++ )
	{
		if ( m_ControlPointOwners[i] == 2 )
			nNumPoints_T++;
		else if ( m_ControlPointOwners[i] == 3 )
			nNumPoints_CT++;
	}

	// set the respawn times for the number of points a team has
	local nRespawnDelay_T = 10 + (nNumPoints_T * 4);
	SendToConsoleServer( "mp_respawnwavetime_t " + nRespawnDelay_T );
	local nRespawnDelay_CT = 10 + (nNumPoints_CT * 4);
	SendToConsoleServer( "mp_respawnwavetime_ct " + nRespawnDelay_CT );

	PrintPointOwnershipInChat( nNumPoints_CT, nNumPoints_T );

	//CT "<font color='#3f74c8'>%s1</font><font color='#5e779f'> %s2</font>"
	// T "<font color='#c3953f'>%s1</font><font color='#9a8661'> %s2</font>"

	// now update the spawn points for the team who just took control of a point
	if ( nTeam == 2 )
	{
		// disable the base spawn
// 		EntFire( "@rl_spawn_T_base_DISABLE","Trigger", "", 0 );
// 		EntFire( "@rl_spawn_T_A_DISABLE","Trigger", "", 0 );
// 		EntFire( "@rl_spawn_T_B_DISABLE","Trigger", "", 0 );
// 		EntFire( "@rl_spawn_T_C_DISABLE","Trigger", "", 0 );

		if ( nPoint == 0 )
		{
			//EntFire( "@rl_spawn_T_A_ENABLE","Trigger", "", 0 );
			//EntFire( "@tr_postcapmoney_T_A","Enable", "", 0 );
			//EntFire( "@tr_postcapmoney_CT_A","Disable", "", 0 );
			EntFire( "@buyzone_A","SetTeam_TerroristOnly", "", 0 );	
		}
		else if ( nPoint == 1 ) // this is point B
		{
			EntFire( "@rl_spawn_T_B_ENABLE","Trigger", "", 0 );
			EntFire( "@rl_spawn_CT_B_DISABLE","Trigger", "", 0 );
			//EntFire( "@tr_postcapmoney_T_B","Enable", "", 0 );
			//EntFire( "@tr_postcapmoney_CT_B","Disable", "", 0 );
			EntFire( "@buyzone_B","SetTeam_TerroristOnly", "", 0 );	
		}
		else
		{
			//EntFire( "@rl_spawn_T_C_ENABLE","Trigger", "", 0 );
			//EntFire( "@tr_postcapmoney_T_C","Enable", "", 0 );
			//EntFire( "@tr_postcapmoney_CT_C","Disable", "", 0 );
			EntFire( "@buyzone_C","SetTeam_TerroristOnly", "", 0 );	
		}

	}
	else if ( nTeam == 3 )
	{
		// disable the base spawn
		//EntFire( "@rl_spawn_CT_base_DISABLE","Trigger", "", 0 );
		EntFire( "@rl_spawn_CT_A_DISABLE","Trigger", "", 0 );
		EntFire( "@rl_spawn_CT_B_DISABLE","Trigger", "", 0 );
		EntFire( "@rl_spawn_CT_C_DISABLE","Trigger", "", 0 );

		if ( nPoint == 0 )
		{
			//EntFire( "@rl_spawn_CT_A_ENABLE","Trigger", "", 0 );
			//EntFire( "@tr_postcapmoney_T_A","Disable", "", 0 );
			//EntFire( "@tr_postcapmoney_CT_A","Enable", "", 0 );
			EntFire( "@buyzone_A","SetTeam_CTOnly", "", 0 );	
		}
		else if ( nPoint == 1 )  // this is point B
		{
			EntFire( "@rl_spawn_CT_B_ENABLE","Trigger", "", 0 );
			EntFire( "@rl_spawn_T_B_DISABLE","Trigger", "", 0 );
			//EntFire( "@tr_postcapmoney_T_B","Disable", "", 0 );
			//EntFire( "@tr_postcapmoney_CT_B","Enable", "", 0 );
			EntFire( "@buyzone_B","SetTeam_CTOnly", "", 0 );	
		}
		else
		{
			//EntFire( "@rl_spawn_CT_C_ENABLE","Trigger", "", 0 );
			//EntFire( "@tr_postcapmoney_T_C","Disable", "", 0 );
			//EntFire( "@tr_postcapmoney_CT_C","Enable", "", 0 );
			EntFire( "@buyzone_C","SetTeam_CTOnly", "", 0 );	
		}
	}

	// clear the team who is currently shutting out and setting it again below if a team is still shutting out
	m_nShutoutTeam = 0;

	// now based on who is winning, we set this convar so when the timer runs out, we have the correct winner: mp_default_team_winner_no_objective					// 0 == draw, 2 == Ts, 3 == CTs
	if ( nNumPoints_CT > nNumPoints_T )
	{
		// counter-terrorists are currently winning
		SendToConsoleServer( "mp_default_team_winner_no_objective 3" );

		//printl( "mp_default_team_winner_no_objective 3" );

		if ( nNumPoints_CT >= m_ControlPointOwners.len() )
		{
			m_nShutoutTeam = 3;
		}
	}
	else if ( nNumPoints_CT < nNumPoints_T )
	{
		// terrorists are currently winning
		SendToConsoleServer( "mp_default_team_winner_no_objective 2" );

		//printl( "mp_default_team_winner_no_objective 2" );

		if ( nNumPoints_T >= m_ControlPointOwners.len() )
		{
			m_nShutoutTeam = 2;
		}
	}
	else
	{
		// noone is currently winning, so set the default winner to "draw"!
		SendToConsoleServer( "mp_default_team_winner_no_objective 0" );

		//printl( "mp_default_team_winner_no_objective 0" );
	}

	if ( m_nShutoutTeam != 2 && m_nShutoutTeam != 3 )
	{
		// everyone can spawn
		SendToConsoleServer( "mp_respawn_on_death_t 1" );
		SendToConsoleServer( "mp_respawn_on_death_ct 1" );
	}

	ShutoutThink();
}

function PrintPointOwnershipInChat( nNumPoints_CT, nNumPoints_T )
{
	// print something in the chat to let players know who owns which point
	local strOwnedCT = "";
	local strOwnedT = "";
	if ( nNumPoints_CT == MAX_CONTROL_POINTS )
	{
		strOwnedCT = "A, B and C";
		strOwnedT = "none";
	}
	else if ( nNumPoints_T == MAX_CONTROL_POINTS )
	{
		strOwnedT = "A, B and C";
		strOwnedCT = "none";
	}
	else
	{
		local nTs = 0;
		local nCTs = 0;

		if ( nNumPoints_T == 0 )
			strOwnedT = "none";
		else
		{
			local zLetterT = "";
			local sAndT = "";
			for ( local i = 0; i<m_ControlPointOwners.len(); i++ )
			{
				if ( m_ControlPointOwners[i] == 2 )
				{	
					if ( i == 0 )
						zLetterT = "A";
					else if ( i == 1 )
						zLetterT = "B";
					else
						zLetterT = "C";

					if ( nTs > 0 )
						sAndT = " and ";

					strOwnedT = strOwnedT + sAndT + zLetterT;
					nTs++;
				}	
			}
		}

		if ( nNumPoints_CT == 0 )
			strOwnedCT = "none";
		else
		{
			local zLetterCT = "";
			local sAndCT = "";
			for ( local i = 0; i<m_ControlPointOwners.len(); i++ )
			{
				if ( m_ControlPointOwners[i] == 3 )
				{	
					if ( i == 0 )
						zLetterCT = "A";
					else if ( i == 1 )
						zLetterCT = "B";
					else
						zLetterCT = "C";

					if ( nCTs > 0 )
						sAndCT = " and ";

					strOwnedCT = strOwnedCT + sAndCT + zLetterCT;
					nCTs++;
				}
			}
		}
	}

	ScriptPrintMessageChatAll( "**** CTs own: "+strOwnedCT+", Ts own: "+strOwnedT+" ****" );
}

function CPDust2_Think()
{
	ShutoutThink();
}

function ShutoutThink()
{
	if ( m_nShutoutTeam == 0 )
	{
		m_bTeamIsShuttingOut = false;
		return;
	}

	if ( m_bTeamIsShuttingOut == false && m_nShutoutTeam > 0 )
	{
		m_bTeamIsShuttingOut = true;
		m_fShutoutStartedTime = Time();
		m_fShutoutNextAlert = Time() + SHUTOUT_ALERT_INTERVAL;
	}

	if ( m_bTeamIsShuttingOut == false )
		return;

// 	if ( m_fShutoutStartedTime + MAX_SHUTOUT_TIME <= Time() )
// 	{
// 		// a team has succefully shut out the other team for 10 seconds
// 		SetWInnerByShutout( m_nShutoutTeam );
// 		return;
// 	}

	if ( m_fShutoutNextAlert <= Time() )
	{
		m_fShutoutNextAlert = Time() + SHUTOUT_ALERT_INTERVAL;
		local nTimeLeft = ((m_fShutoutStartedTime + MAX_SHUTOUT_TIME + 1) - Time());
		nTimeLeft = nTimeLeft.tointeger();
		local szSeconds = "seconds";
		if ( nTimeLeft == 1 )
			szSeconds = "second";

		if ( m_nShutoutTeam == 2 )
		{
			//ScriptPrintMessageCenterAll( "Terrorists own all the points!\nMatch will end in " + nTimeLeft + " " + szSeconds );
			ScriptPrintMessageCenterAll( "Terrorists own all the points!\nCounter-Terrorists can longer respawn!" );
			SendToConsoleServer( "mp_respawn_on_death_t 1" );
			// CT's can no longer spawn!
			SendToConsoleServer( "mp_respawn_on_death_ct 0" );
		}
		else if ( m_nShutoutTeam == 3)
		{
			ScriptPrintMessageCenterAll( "Counter-Terrorists own all the points!\nTerrorists can longer respawn!" );
			// T's can no longer spawn!
			SendToConsoleServer( "mp_respawn_on_death_t 0" );
			SendToConsoleServer( "mp_respawn_on_death_ct 1" );
		}
	}
}


function SetWInnerByShutout( nTeam )
{
	m_nShutoutTeam = 0;
	m_bTeamIsShuttingOut = false;
	m_fShutoutNextAlert = 0;

	if ( nTeam == 2 )
	{
		EntFire( "@game_round_end","EndRound_TerroristsWin", "7", 0 );
		EntFire( "@game_score","AddScoreTerrorist", "", 0 );
	}
	else if ( nTeam == 3 )
	{
		EntFire( "@game_round_end","EndRound_CounterTerroristsWin", "7", 0 );
		EntFire( "@game_score","AddScoreCT", "", 0 );
	}
}		